<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'recipient_name',
        'recipient_phone',
        'recipient_address',
        'recipient_city',
        'cod_amount',
        'parcel_weight',
        'parcel_details',
        'status',
        'tracking_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
