<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Parcel extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'tracking_id',
        'recipient_name',
        'address',
        'contact',
        'cod_amount',
        'city',
        'zone',
        'status',
        'booking_date',
        'assigned_rider_id',
        'seller_id',
        'is_scanned',
        'order_type',
        'order_reference_number',
        'items',
        'booking_weight',
        'pickup_city',
        'pickup_address',
        'return_city',
        'return_address',
        'order_detail',
        'notes',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'booking_date' => 'date',
        'cod_amount' => 'decimal:2',
        'booking_weight' => 'decimal:2',
        'is_scanned' => 'boolean',
    ];

    /**
     * Get the seller that owns the parcel.
     */
    public function seller()
    {
        return $this->belongsTo(User::class, 'seller_id');
    }

    /**
     * Get the rider assigned to the parcel.
     */
    public function rider()
    {
        return $this->belongsTo(Rider::class, 'assigned_rider_id');
    }

    /**
     * Get the complaints for the parcel.
     */
    public function complaints()
    {
        return $this->hasMany(Complaint::class);
    }

    /**
     * Generate a unique tracking ID.
     */
    public static function generateTrackingId(): string
    {
        do {
            $trackingId = 'PCL' . rand(100000, 999999);
        } while (self::where('tracking_id', $trackingId)->exists());

        return $trackingId;
    }
}
