<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pricing extends Model
{
    use HasFactory;

    protected $table = 'pricing_rates';

    protected $fillable = [
        'name',
        'code',
        'currency',
        'base_rate',
        'per_kg_rate',
        'per_km_rate',
        'min_charge',
        'zone',
        'effective_from',
        'effective_to',
        'status',
        'notes',
    ];

    protected $casts = [
        'base_rate' => 'decimal:2',
        'per_kg_rate' => 'decimal:2',
        'per_km_rate' => 'decimal:2',
        'min_charge' => 'decimal:2',
        'effective_from' => 'date',
        'effective_to' => 'date',
    ];
}