<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReportSchedule extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'type', // financial, operational, custom
        'format', // csv, xlsx, pdf
        'frequency', // daily, weekly, monthly
        'recipients', // comma-separated emails
        'filters', // json
        'next_run_at',
        'last_run_at',
        'is_active',
    ];

    protected $casts = [
        'filters' => 'array',
        'is_active' => 'boolean',
        'next_run_at' => 'datetime',
        'last_run_at' => 'datetime',
    ];
}