<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Rider extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'phone',
        'zone',
        'avatar',
        'branch_id',
    ];

    /**
     * Get the branch that owns the rider.
     */
    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    /**
     * Get the parcels assigned to the rider.
     */
    public function parcels()
    {
        return $this->hasMany(Parcel::class, 'assigned_rider_id');
    }

    /**
     * Computed current status based on parcels in progress.
     * available: no active parcels; on_duty: has active parcels.
     */
    public function getCurrentStatusAttribute()
    {
        $activeCount = $this->parcels()
            ->whereIn('status', ['Picked Up', 'Out for Delivery'])
            ->count();
        return $activeCount > 0 ? 'on_duty' : 'available';
    }

    /**
     * Helper to check if rider is on duty.
     */
    public function isOnDuty(): bool
    {
        return $this->current_status === 'on_duty';
    }
}
