<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Span extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'category',
        'owner',
        'status',
        'start_date',
        'end_date',
        'notes',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
    ];

    public function scopeSearch($query, $q)
    {
        if (!$q) { return $query; }
        return $query->where(function ($sub) use ($q) {
            $sub->where('name', 'like', "%$q%")
                ->orWhere('code', 'like', "%$q%")
                ->orWhere('category', 'like', "%$q%")
                ->orWhere('owner', 'like', "%$q%")
                ->orWhere('notes', 'like', "%$q%");
        });
    }

    public function scopeStatus($query, $status)
    {
        if (!$status) { return $query; }
        return $query->where('status', $status);
    }
}