<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TaxFiling extends Model
{
    use HasFactory;

    protected $fillable = [
        'filing_type',
        'period',
        'due_date',
        'filed_on',
        'tax_amount',
        'status',
        'reference_number',
        'document_path',
        'filed_by',
    ];

    protected $casts = [
        'due_date' => 'date',
        'filed_on' => 'date',
    ];

    public function filedBy()
    {
        return $this->belongsTo(User::class, 'filed_by');
    }
}
