<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ZoneRate extends Model
{
    use HasFactory;

    protected $table = 'zone_rates';

    protected $fillable = [
        'name',
        'code',
        'zone',
        'currency',
        'base_rate',
        'additional_per_kg',
        'remote_area_fee',
        'fuel_surcharge_percent',
        'effective_from',
        'effective_to',
        'status',
        'notes',
    ];

    protected $casts = [
        'base_rate' => 'decimal:2',
        'additional_per_kg' => 'decimal:2',
        'remote_area_fee' => 'decimal:2',
        'fuel_surcharge_percent' => 'decimal:2',
        'effective_from' => 'datetime',
        'effective_to' => 'datetime',
    ];
}