<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('parcels', function (Blueprint $table) {
            $table->id();
            $table->string('tracking_id')->unique();
            $table->string('recipient_name');
            $table->text('address');
            $table->string('contact');
            $table->decimal('cod_amount', 10, 2);
            $table->string('city');
            $table->string('zone');
            $table->enum('status', [
                'Pending', 
                'Picked Up', 
                'In Transit', 
                'Delivered', 
                'Returned', 
                'Failed',
                'Unbooked',
                'In Warehouse',
                'Out for Delivery',
                'Attempted',
                'Out for Return',
                'Shipper Advice',
                'Branch Shift',
                'Cancelled',
                'Lost',
                'Stolen',
                'Damaged'
            ])->default('Pending');
            $table->date('booking_date');
            $table->foreignId('assigned_rider_id')->nullable()->constrained('riders')->onDelete('set null');
            $table->foreignId('seller_id')->constrained('users')->onDelete('cascade');
            $table->boolean('is_scanned')->default(false);
            
            // Additional fields
            $table->string('order_type')->nullable();
            $table->string('order_reference_number')->nullable();
            $table->integer('items')->nullable();
            $table->decimal('booking_weight', 8, 2)->nullable();
            $table->string('pickup_city')->nullable();
            $table->text('pickup_address')->nullable();
            $table->string('return_city')->nullable();
            $table->text('return_address')->nullable();
            $table->text('order_detail')->nullable();
            $table->text('notes')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('parcels');
    }
};
