<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cod_pending_reports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('parcel_id')->constrained('parcels')->onDelete('cascade');
            $table->foreignId('rider_id')->constrained('users')->onDelete('cascade');
            $table->decimal('cod_amount', 10, 2);
            $table->date('delivery_date');
            $table->date('due_date');
            $table->integer('days_pending')->default(0);
            $table->enum('status', ['pending', 'overdue', 'collected', 'cancelled'])->default('pending');
            $table->text('notes')->nullable();
            $table->timestamp('collected_at')->nullable();
            $table->timestamps();

            $table->index(['rider_id', 'status']);
            $table->index(['delivery_date', 'status']);
            $table->index(['due_date', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cod_pending_reports');
    }
};
