<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cod_variance_reports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('rider_id')->constrained('users')->onDelete('cascade');
            $table->date('variance_date');
            $table->decimal('expected_amount', 10, 2);
            $table->decimal('collected_amount', 10, 2);
            $table->decimal('variance_amount', 10, 2);
            $table->decimal('percentage_variance', 5, 2)->default(0);
            $table->enum('variance_type', ['shortage', 'excess', 'exact'])->default('exact');
            $table->enum('status', ['pending', 'investigating', 'resolved', 'accepted'])->default('pending');
            $table->text('reason')->nullable();
            $table->text('resolution_notes')->nullable();
            $table->foreignId('investigated_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('resolved_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('resolved_at')->nullable();
            $table->timestamps();

            $table->index(['rider_id', 'variance_date']);
            $table->index(['status', 'variance_date']);
            $table->index(['variance_type', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cod_variance_reports');
    }
};
