<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('journal_entry_lines')) {
            Schema::disableForeignKeyConstraints();
            Schema::table('journal_entry_lines', function (Blueprint $table) {
                // Get the schema manager
                $schemaManager = Schema::getConnection()->getDoctrineSchemaManager();
                // Get the foreign keys for the table
                $foreignKeys = $schemaManager->listTableForeignKeys('journal_entry_lines');

                // Check if a foreign key on 'account_id' exists and drop it
                foreach ($foreignKeys as $foreignKey) {
                    if (in_array('account_id', $foreignKey->getLocalColumns())) {
                        $table->dropForeign($foreignKey->getName());
                        break; // Assuming only one FK on this column
                    }
                }

                // Re-add FK to accounts table
                $table->foreign('account_id')->references('id')->on('accounts')->onDelete('cascade');
            });
            Schema::enableForeignKeyConstraints();
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('journal_entry_lines')) {
            Schema::table('journal_entry_lines', function (Blueprint $table) {
                try {
                    $table->dropForeign(['account_id']);
                } catch (\Throwable $e) {
                    // ignore if not exists
                }
                // Best-effort restore to company_accounts if it exists
                if (Schema::hasTable('company_accounts')) {
                    $table->foreign('account_id')->references('id')->on('company_accounts')->onDelete('cascade');
                }
            });
        }
    }
};
