<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tax_filings', function (Blueprint $table) {
            $table->id();
            $table->string('filing_type'); // e.g., GST-R1, ITR-4
            $table->string('period'); // e.g., '2025-10' or 'Q4 2025'
            $table->date('due_date');
            $table->date('filed_on')->nullable();
            $table->decimal('tax_amount', 12, 2)->nullable();
            $table->string('status')->default('pending'); // pending, filed, overdue
            $table->string('reference_number')->nullable();
            $table->string('document_path')->nullable();
            $table->foreignId('filed_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tax_filings');
    }
};
