<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('cheques', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bank_account_id')->constrained('bank_accounts')->cascadeOnDelete();
            $table->string('cheque_number')->unique();
            $table->string('type'); // incoming, outgoing
            $table->string('payee')->nullable();
            $table->decimal('amount', 12, 2);
            $table->date('issue_date');
            $table->date('due_date')->nullable();
            $table->string('status')->default('issued'); // issued, deposited, cleared, bounced, cancelled
            $table->date('deposit_date')->nullable();
            $table->date('cleared_at')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cheques');
    }
};
