<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('bank_discrepancies', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bank_reconciliation_line_id')->nullable()->constrained('bank_reconciliation_lines')->cascadeOnDelete();
            $table->string('source')->default('bank'); // bank, ledger, manual
            $table->date('txn_date')->nullable();
            $table->string('description');
            $table->decimal('amount', 12, 2);
            $table->boolean('resolved')->default(false);
            $table->timestamp('resolved_at')->nullable();
            $table->text('resolution_notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('bank_discrepancies');
    }
};
