<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('internal_audits', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('scope')->nullable();
            $table->date('audit_date');
            $table->string('auditor')->nullable();
            $table->string('status')->default('open'); // open,in_progress,closed
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('internal_audits');
    }
};
