<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('external_audits', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('auditor')->nullable();
            $table->string('firm')->nullable();
            $table->date('audit_date');
            $table->string('status')->default('open'); // open,in_progress,closed
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('external_audits');
    }
};
