<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('compliance_cases', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('regulation')->nullable();
            $table->date('due_date')->nullable();
            $table->string('owner')->nullable();
            $table->string('status')->default('open'); // open,in_progress,closed
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('compliance_cases');
    }
};
