<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('sox_controls', function (Blueprint $table) {
            $table->id();
            $table->string('control_name');
            $table->string('framework')->default('SOX');
            $table->string('owner')->nullable();
            $table->string('status')->default('active'); // active,inactive,deprecated
            $table->date('test_date')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sox_controls');
    }
};
