<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('risk_assessments', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('area')->nullable();
            $table->string('owner')->nullable();
            $table->string('risk_level')->default('medium'); // low, medium, high, critical
            $table->string('status')->default('open'); // open, in_progress, mitigated
            $table->date('assessment_date')->nullable();
            $table->text('mitigation_plan')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('risk_assessments');
    }
};
