<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('marketing_alerts', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('status')->default('new'); // new, acknowledged, snoozed, resolved
            $table->string('severity')->default('info'); // info, warning, critical
            $table->string('category')->nullable(); // campaign, compliance, rate, expiry
            $table->boolean('is_read')->default(false);
            $table->timestamp('triggered_at')->nullable();
            $table->timestamp('snooze_until')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('marketing_alerts');
    }
};