<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('zone_rates', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code')->unique();
            $table->string('zone');
            $table->string('currency', 3)->default('USD');
            $table->decimal('base_rate', 10, 2)->default(0);
            $table->decimal('additional_per_kg', 10, 2)->default(0);
            $table->decimal('remote_area_fee', 10, 2)->nullable();
            $table->decimal('fuel_surcharge_percent', 5, 2)->default(0);
            $table->dateTime('effective_from')->nullable();
            $table->dateTime('effective_to')->nullable();
            $table->string('status')->default('active');
            $table->text('notes')->nullable();
            $table->timestamps();

            $table->index(['zone', 'status']);
            $table->index(['effective_from', 'effective_to']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('zone_rates');
    }
};