<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('territories', function (Blueprint $table) {
            if (!Schema::hasColumn('territories', 'target_amount')) {
                $table->decimal('target_amount', 15, 2)->nullable()->after('name');
            }
            if (!Schema::hasColumn('territories', 'manager')) {
                $table->string('manager')->nullable()->after('target_amount');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('territories', function (Blueprint $table) {
            $table->dropColumn(['target_amount', 'manager']);
        });
    }
};
