<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('expenses', 'vendor_id')) {
            Schema::table('expenses', function (Blueprint $table) {
                $table->foreignId('vendor_id')->nullable()->constrained('vendors');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('expenses', 'vendor_id')) {
            Schema::table('expenses', function (Blueprint $table) {
                // Drops both foreign key and column using Laravel helper
                $table->dropConstrainedForeignId('vendor_id');
            });
        }
    }
};