<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('expenses')) {
            Schema::table('expenses', function (Blueprint $table) {
                if (!Schema::hasColumn('expenses', 'expense_category')) {
                    $table->string('expense_category')->after('id');
                }
                if (!Schema::hasColumn('expenses', 'status')) {
                    $table->string('status')->default('pending')->after('receipt');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('expenses')) {
            Schema::table('expenses', function (Blueprint $table) {
                if (Schema::hasColumn('expenses', 'expense_category')) {
                    $table->dropColumn('expense_category');
                }
                if (Schema::hasColumn('expenses', 'status')) {
                    $table->dropColumn('status');
                }
            });
        }
    }
};