<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bags', function (Blueprint $table) {
            $table->foreignId('origin_branch_id')->constrained('branches')->after('id');
            $table->foreignId('destination_branch_id')->constrained('branches')->after('origin_branch_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bags', function (Blueprint $table) {
            $table->dropForeign(['origin_branch_id']);
            $table->dropForeign(['destination_branch_id']);
            $table->dropColumn(['origin_branch_id', 'destination_branch_id']);
        });
    }
};
