<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Bag;
use App\Models\Rider;
use App\Models\Branch;

class BagOpenSeeder extends Seeder
{
    /**
     * Seed an open bag to test add/seal flows.
     */
    public function run(): void
    {
        $rider = Rider::first();
        $origin = Branch::first();
        $destination = Branch::skip(1)->first() ?? $origin;

        $bag = Bag::firstOrCreate(
            ['bag_number' => 'BAG999999'],
            [
                'status' => 'open',
                'rider_id' => $rider?->id,
                'origin_branch_id' => $origin?->id,
                'destination_branch_id' => $destination?->id,
            ]
        );

        echo "Open bag id: {$bag->id}\n";
    }
}