<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Bank;

class BankSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $banks = [
            [
                'bank_name' => 'Habib Bank Limited (HBL)',
                'bank_code' => 'HBL',
                'swift_code' => 'HABBPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'National Bank of Pakistan (NBP)',
                'bank_code' => 'NBP',
                'swift_code' => 'NBPAPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'United Bank Limited (UBL)',
                'bank_code' => 'UBL',
                'swift_code' => 'UNILPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'MCB Bank Limited',
                'bank_code' => 'MCB',
                'swift_code' => 'MUCBPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'Allied Bank Limited (ABL)',
                'bank_code' => 'ABL',
                'swift_code' => 'ABPAPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'Bank Alfalah Limited',
                'bank_code' => 'BAFL',
                'swift_code' => 'ALFHPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'Meezan Bank Limited',
                'bank_code' => 'MEBL',
                'swift_code' => 'MEZNPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'Bank Al Habib Limited',
                'bank_code' => 'BAHL',
                'swift_code' => 'BAHBPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'Faysal Bank Limited',
                'bank_code' => 'FBL',
                'swift_code' => 'FAYSPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'Standard Chartered Bank',
                'bank_code' => 'SCB',
                'swift_code' => 'SCBLPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'JS Bank Limited',
                'bank_code' => 'JSBL',
                'swift_code' => 'JSBLPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'Askari Bank Limited',
                'bank_code' => 'AKBL',
                'swift_code' => 'ASKBPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'Bank of Punjab',
                'bank_code' => 'BOP',
                'swift_code' => 'PUNJPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'Soneri Bank Limited',
                'bank_code' => 'SNBL',
                'swift_code' => 'SONEPKKA',
                'is_active' => true,
            ],
            [
                'bank_name' => 'Silk Bank Limited',
                'bank_code' => 'SILK',
                'swift_code' => 'SILKPKKA',
                'is_active' => true,
            ],
        ];

        foreach ($banks as $bank) {
            Bank::create($bank);
        }
    }
}
