<?php

namespace Database\Seeders;

use App\Models\Complaint;
use Illuminate\Database\Seeder;

class ComplaintSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Complaint::create([
            'parcel_id' => 5,
            'subject' => 'Parcel Returned Undelivered',
            'description' => 'The parcel was returned but the reason is unclear. Please investigate.',
            'status' => 'In Progress',
            'seller_id' => 4,
        ]);

        Complaint::create([
            'parcel_id' => 2,
            'subject' => 'Delivery is delayed',
            'description' => 'The parcel is still in transit after 3 days. The customer is asking for an update.',
            'status' => 'Open',
            'seller_id' => 4,
        ]);

        Complaint::create([
            'parcel_id' => 1,
            'subject' => 'COD amount not remitted',
            'description' => 'The parcel was delivered 5 days ago but the COD amount has not been credited to my wallet.',
            'status' => 'Resolved',
            'seller_id' => 4,
        ]);
    }
}
