<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ComplianceDocument;

class ComplianceDocumentSeeder extends Seeder
{
    public function run(): void
    {
        $items = [
            [
                'title' => 'Privacy Policy',
                'code' => 'PRIVACY_POLICY',
                'category' => 'policy',
                'description' => 'Company privacy policy for data protection compliance.',
                'content' => 'We value your privacy... \n\n1. Data Collection... \n2. Usage...',
                'status' => 'active',
                'effective_date' => now()->subMonths(3)->toDateString(),
                'is_required' => true,
            ],
            [
                'title' => 'GDPR Notice',
                'code' => 'GDPR_NOTICE',
                'category' => 'regulatory',
                'description' => 'Notice for GDPR compliance for EU residents.',
                'content' => 'Under GDPR, you have rights...',
                'status' => 'draft',
                'effective_date' => now()->toDateString(),
                'is_required' => true,
            ],
        ];

        foreach ($items as $row) {
            ComplianceDocument::firstOrCreate(['code' => $row['code']], $row);
        }
    }
}