<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Contract;

class ContractSeeder extends Seeder
{
    public function run(): void
    {
        Contract::truncate();

        Contract::create([
            'title' => 'Standard Service Agreement',
            'contract_number' => 'CSA-2025-001',
            'merchant_id' => null,
            'start_date' => now()->toDateString(),
            'end_date' => now()->addYear()->toDateString(),
            'status' => 'active',
            'file_path' => null,
            'notes' => 'Primary agreement for merchant onboarding.',
        ]);

        Contract::create([
            'title' => 'Promotional Rate Addendum',
            'contract_number' => 'PRA-2025-002',
            'merchant_id' => null,
            'start_date' => now()->subMonths(2)->toDateString(),
            'end_date' => now()->addMonths(10)->toDateString(),
            'status' => 'active',
            'file_path' => null,
            'notes' => 'Adds seasonal promotional rates for select zones.',
        ]);

        Contract::create([
            'title' => 'Legacy Partner Agreement',
            'contract_number' => 'LPA-2024-003',
            'merchant_id' => null,
            'start_date' => now()->subYear()->toDateString(),
            'end_date' => now()->subMonths(1)->toDateString(),
            'status' => 'expired',
            'file_path' => null,
            'notes' => 'Legacy partner contract that has now expired.',
        ]);
    }
}