<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class DiscountSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $now = now();

        DB::table('discount_rates')->insert([
            [
                'name' => 'Global Autumn Sale',
                'code' => 'DISC-AUTUMN-10',
                'type' => 'percentage',
                'amount' => 10,
                'currency' => 'USD',
                'applies_to' => 'global',
                'target_code' => null,
                'min_order_value' => 0,
                'max_discount_value' => 50,
                'effective_from' => $now->copy()->subDays(3),
                'effective_to' => $now->copy()->addDays(27),
                'status' => 'active',
                'notes' => 'Site-wide autumn promotion.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Zone Europe Promo',
                'code' => 'DISC-EU-5',
                'type' => 'percentage',
                'amount' => 5,
                'currency' => 'EUR',
                'applies_to' => 'zone',
                'target_code' => 'EU',
                'min_order_value' => 20,
                'max_discount_value' => 30,
                'effective_from' => $now->copy()->subWeek(),
                'effective_to' => $now->copy()->addWeeks(3),
                'status' => 'active',
                'notes' => 'Only for Europe zone.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Merchant ABC Fixed Discount',
                'code' => 'DISC-ABC-15',
                'type' => 'fixed',
                'amount' => 15,
                'currency' => 'USD',
                'applies_to' => 'merchant',
                'target_code' => 'MER-ABC',
                'min_order_value' => 50,
                'max_discount_value' => 60,
                'effective_from' => $now->copy()->addDays(1),
                'effective_to' => $now->copy()->addDays(45),
                'status' => 'inactive',
                'notes' => 'Pending merchant activation.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Service Express Archived',
                'code' => 'DISC-EXP-20',
                'type' => 'percentage',
                'amount' => 20,
                'currency' => 'USD',
                'applies_to' => 'service',
                'target_code' => 'EXPRESS',
                'min_order_value' => 0,
                'max_discount_value' => 100,
                'effective_from' => $now->copy()->subMonths(2),
                'effective_to' => $now->copy()->subMonth(),
                'status' => 'archived',
                'notes' => 'Expired sprint campaign.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
        ]);
    }
}