<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\DocumentTemplate;

class DocumentTemplateSeeder extends Seeder
{
    public function run(): void
    {
        $data = [
            [
                'title' => 'Welcome Email',
                'code' => 'WELCOME_EMAIL',
                'category' => 'communication',
                'description' => 'Template for new merchant welcome email.',
                'content' => 'Hello {{name}}, welcome to our platform! ...',
                'status' => 'active',
                'version' => '1.0',
                'is_global' => true,
                'notes' => 'Used by onboarding team.',
            ],
            [
                'title' => 'Rate Change Notice',
                'code' => 'RATE_CHANGE_NOTICE',
                'category' => 'notification',
                'description' => 'Template for rate change notices.',
                'content' => 'Dear {{merchant}}, effective {{date}} your rates will ...',
                'status' => 'draft',
                'version' => '1.0',
                'is_global' => false,
                'notes' => null,
            ],
            [
                'title' => 'Contract Amendment',
                'code' => 'CONTRACT_AMENDMENT',
                'category' => 'legal',
                'description' => 'Template for amending existing contracts.',
                'content' => 'This amendment is made on {{date}} between ...',
                'status' => 'active',
                'version' => '1.1',
                'is_global' => true,
                'notes' => 'Reviewed by legal team.',
            ],
        ];

        foreach ($data as $row) {
            DocumentTemplate::firstOrCreate(['code' => $row['code']], $row);
        }
    }
}