<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;

class FinancePermissionsSeeder extends Seeder
{
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        // Define finance permissions
        $permissions = [
            'finance.view',
            'finance.add',
            'finance.edit',
            'finance.delete',
        ];

        foreach ($permissions as $permission) {
            Permission::findOrCreate($permission, 'web');
        }

        // Get or create the Finance role
        $financeRole = Role::findOrCreate('Finance', 'web');

        // Assign all defined permissions to the Finance role
        $financeRole->givePermissionTo($permissions);

        // Grant Super Admin all permissions
        $superAdminRole = Role::findOrCreate('Super Admin', 'web');
        $superAdminRole->givePermissionTo(Permission::all());
    }
}
