<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\MarketingAlert;
use Illuminate\Support\Carbon;

class MarketingAlertSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $alerts = [
            [
                'title' => 'High CTR on Campaign A',
                'description' => 'Campaign A is performing above expectations. Consider increasing budget.',
                'status' => 'new',
                'severity' => 'info',
                'category' => 'campaign',
                'triggered_at' => Carbon::now()->subHours(6),
            ],
            [
                'title' => 'Contract Expiry: Merchant X',
                'description' => 'Rate contract for Merchant X expires in 7 days.',
                'status' => 'new',
                'severity' => 'warning',
                'category' => 'expiry',
                'triggered_at' => Carbon::now()->subDays(1),
            ],
            [
                'title' => 'Compliance Issue Detected',
                'description' => 'Missing KYC document for Merchant Y. Action required.',
                'status' => 'new',
                'severity' => 'critical',
                'category' => 'compliance',
                'triggered_at' => Carbon::now()->subHours(30),
            ],
            [
                'title' => 'Rate Review Suggested',
                'description' => 'Zone B discount causing margin drop. Review rates.',
                'status' => 'new',
                'severity' => 'warning',
                'category' => 'rate',
                'triggered_at' => Carbon::now()->subDays(2),
            ],
        ];

        foreach ($alerts as $data) {
            MarketingAlert::create($data);
        }
    }
}