<?php

namespace Database\Seeders;

use App\Models\Parcel;
use Illuminate\Database\Seeder;

class ParcelSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Parcel::firstOrCreate(['tracking_id' => 'PCL162818'], [
            'recipient_name' => 'Ahmed Khan',
            'address' => 'House 123, Street 4, G-8/1',
            'contact' => '0333-5551234',
            'cod_amount' => 1500,
            'city' => 'Islamabad',
            'zone' => 'A',
            'status' => 'Delivered',
            'booking_date' => now()->subDays(2),
            'seller_id' => 4,
            'order_reference_number' => 'REF001',
            'branch_id' => 1,
        ]);

        Parcel::firstOrCreate(['tracking_id' => 'PCL162819'], [
            'recipient_name' => 'Fatima Ali',
            'address' => 'Office 404, 4th Floor, Business Tower, Blue Area',
            'contact' => '0300-9876543',
            'cod_amount' => 2500,
            'city' => 'Islamabad',
            'zone' => 'B',
            'status' => 'In Transit',
            'booking_date' => now()->subDay(),
            'seller_id' => 4,
            'assigned_rider_id' => 1,
            'order_reference_number' => 'REF002',
            'branch_id' => 1,
        ]);

        Parcel::firstOrCreate(['tracking_id' => 'PCL162820'], [
            'recipient_name' => 'Zainab Corporation',
            'address' => 'Plot 55, Industrial Area, I-9/3',
            'contact' => '0312-3456789',
            'cod_amount' => 500,
            'city' => 'Islamabad',
            'zone' => 'C',
            'status' => 'Pending',
            'booking_date' => now(),
            'seller_id' => 4,
            'order_reference_number' => 'REF003',
            'branch_id' => 1,
        ]);

        Parcel::firstOrCreate(['tracking_id' => 'PCL162821'], [
            'recipient_name' => 'Sana Ahmed',
            'address' => 'B-567, Block 10, Gulshan-e-Iqbal',
            'contact' => '0345-1122334',
            'cod_amount' => 3000,
            'city' => 'Karachi',
            'zone' => 'A',
            'status' => 'Picked Up',
            'booking_date' => now()->subDays(8),
            'seller_id' => 4,
            'assigned_rider_id' => 2,
            'order_reference_number' => 'REF004',
            'branch_id' => 2,
        ]);

        Parcel::firstOrCreate(['tracking_id' => 'PCL162822'], [
            'recipient_name' => 'Kamran Traders',
            'address' => 'Shop 8, Main Market, F-7 Markaz',
            'contact' => '0321-4455667',
            'cod_amount' => 1200,
            'city' => 'Islamabad',
            'zone' => 'B',
            'status' => 'Returned',
            'booking_date' => now()->subDays(3),
            'seller_id' => 4,
            'order_reference_number' => 'REF005',
            'branch_id' => 1,
        ]);

        Parcel::firstOrCreate(['tracking_id' => 'PCL162823'], [
            'recipient_name' => 'Global Imports',
            'address' => 'Warehouse 12, Site Area',
            'contact' => '0334-7890123',
            'cod_amount' => 7500,
            'city' => 'Karachi',
            'zone' => 'C',
            'status' => 'Delivered',
            'booking_date' => now()->subDays(10),
            'seller_id' => 5,
            'assigned_rider_id' => 3,
            'order_reference_number' => 'REF006',
            'branch_id' => 2,
        ]);

        Parcel::firstOrCreate(['tracking_id' => 'PCL162824'], [
            'recipient_name' => 'Hassan Ali',
            'address' => 'Apartment 15, Park Towers, Clifton',
            'contact' => '0301-2345678',
            'cod_amount' => 850,
            'city' => 'Karachi',
            'zone' => 'A',
            'status' => 'Out for Delivery',
            'booking_date' => now()->subDays(9),
            'seller_id' => 4,
            'assigned_rider_id' => 3,
            'order_reference_number' => 'REF007',
            'branch_id' => 2,
        ]);
    }
}
