<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Pricing;
use Illuminate\Support\Carbon;

class PricingSeeder extends Seeder
{
    public function run(): void
    {
        $data = [
            [
                'name' => 'Standard Domestic',
                'code' => 'STD-DOM',
                'currency' => 'INR',
                'base_rate' => 50.00,
                'per_kg_rate' => 10.00,
                'per_km_rate' => 2.50,
                'min_charge' => 75.00,
                'zone' => 'DOM-STD',
                'effective_from' => Carbon::now()->startOfMonth(),
                'effective_to' => null,
                'status' => 'active',
                'notes' => 'Base domestic rate for standard deliveries.',
            ],
            [
                'name' => 'Express Domestic',
                'code' => 'EXP-DOM',
                'currency' => 'INR',
                'base_rate' => 100.00,
                'per_kg_rate' => 20.00,
                'per_km_rate' => 5.00,
                'min_charge' => 125.00,
                'zone' => 'DOM-EXP',
                'effective_from' => Carbon::now()->startOfMonth(),
                'effective_to' => null,
                'status' => 'active',
                'notes' => 'Express domestic rate for fast deliveries.',
            ],
            [
                'name' => 'International Economy',
                'code' => 'INT-ECO',
                'currency' => 'USD',
                'base_rate' => 15.00,
                'per_kg_rate' => 8.50,
                'per_km_rate' => null,
                'min_charge' => 25.00,
                'zone' => 'INT-ECO',
                'effective_from' => Carbon::now()->subMonths(1)->startOfMonth(),
                'effective_to' => null,
                'status' => 'active',
                'notes' => 'International economy shipments.',
            ],
            [
                'name' => 'Archived Example',
                'code' => 'ARCH-EX',
                'currency' => 'INR',
                'base_rate' => 60.00,
                'per_kg_rate' => 12.00,
                'per_km_rate' => 3.00,
                'min_charge' => 80.00,
                'zone' => 'DOM-OLD',
                'effective_from' => Carbon::now()->subYears(1)->startOfYear(),
                'effective_to' => Carbon::now()->subMonths(6)->endOfMonth(),
                'status' => 'archived',
                'notes' => 'Old domestic rate archived.',
            ],
        ];

        foreach ($data as $item) {
            Pricing::updateOrCreate(
                ['code' => $item['code']],
                $item
            );
        }
    }
}