<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()["\Spatie\Permission\PermissionRegistrar"]->forgetCachedPermissions();

        // create permissions
        Permission::firstOrCreate(['name' => 'manage users']);
        Permission::firstOrCreate(['name' => 'view dashboard']);

        // create roles and assign created permissions
        $role = Role::firstOrCreate(['name' => 'Staff'])
            ->givePermissionTo('view dashboard');

        $role = Role::firstOrCreate(['name' => 'Admin'])
            ->givePermissionTo(['manage users', 'view dashboard']);

        Role::firstOrCreate(['name' => 'Super Admin']);
        Role::firstOrCreate(['name' => 'Finance']);
        Role::firstOrCreate(['name' => 'Branch Operator']);
        Role::firstOrCreate(['name' => 'Seller']);
        Role::firstOrCreate(['name' => 'Marketing Manager']);
        Role::firstOrCreate(['name' => 'Support']);
    }
}
