<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Span;

class SpanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $spans = [
            [
                'name' => 'Q4 Marketing Campaign',
                'code' => 'Q4-MKT-2025',
                'category' => 'Marketing',
                'owner' => 'Marketing Team',
                'status' => 'active',
                'start_date' => now()->subMonths(1)->toDateString(),
                'end_date' => now()->addMonths(2)->toDateString(),
                'notes' => 'Seasonal push for holiday sales.',
            ],
            [
                'name' => 'Website Revamp',
                'code' => 'WEB-REVAMP-2025',
                'category' => 'IT',
                'owner' => 'IT Department',
                'status' => 'inactive',
                'start_date' => now()->subMonths(3)->toDateString(),
                'end_date' => now()->addMonths(6)->toDateString(),
                'notes' => 'Pending budget approval.',
            ],
            [
                'name' => 'Warehouse Expansion',
                'code' => 'WH-EXP-MLT',
                'category' => 'Operations',
                'owner' => 'Ops Team',
                'status' => 'archived',
                'start_date' => now()->subYear()->toDateString(),
                'end_date' => now()->subMonths(6)->toDateString(),
                'notes' => 'Completed last year with success metrics achieved.',
            ],
        ];

        foreach ($spans as $data) {
            Span::firstOrCreate(['code' => $data['code']], $data);
        }
    }
}