<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class SuperAdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Ensure role exists in Spatie
        Role::firstOrCreate(['name' => 'Super Admin']);

        // Create multiple super admin accounts for testing
        $superAdmins = [
            [
                'name' => 'Super Admin',
                'email' => 'admin@admin.com',
                'password' => 'password',
                'role' => 'super-admin',
            ],
            [
                'name' => 'Super Admin 2',
                'email' => 'superadmin@example.com',
                'password' => 'superadmin123',
                'role' => 'super-admin',
            ],
            [
                'name' => 'Test Super Admin',
                'email' => 'test@admin.com',
                'password' => 'test123',
                'role' => 'super-admin',
            ],
        ];

        echo "\n=== Super Admin Accounts Created ===\n\n";

        foreach ($superAdmins as $admin) {
            $user = User::firstOrCreate(
                ['email' => $admin['email']],
                [
                    'name' => $admin['name'],
                    'password' => Hash::make($admin['password']),
                    'role' => $admin['role'],
                    'is_approved' => true,
                ]
            );

            // Assign canonical Spatie role
            $user->assignRole('Super Admin');

            echo "✓ {$admin['name']}\n";
            echo "  Email: {$admin['email']}\n";
            echo "  Password: {$admin['password']}\n";
            echo "  Role: {$admin['role']}\n\n";
        }

        echo "=== All Super Admin accounts ready! ===\n\n";
    }
}
