<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Super Admin
        $superAdmin = User::firstOrCreate(
            ['email' => 'admin@alwasisofttech.com'],
            [
                'name' => 'Super Admin',
                'company_name' => 'Al-wasi Soft Tech HQ',
                'password' => Hash::make('password'),
                'avatar' => 'https://picsum.photos/seed/admin1/100/100',
            ]
        );
        $superAdmin->assignRole('Super Admin');

        // Sam - Super Admin
        $sam = User::firstOrCreate(
            ['email' => 'sam@alwasisofttech.com'],
            [
                'name' => 'Sam',
                'company_name' => 'Al-wasi Soft Tech HQ',
                'password' => Hash::make('password'),
                'avatar' => 'https://picsum.photos/seed/sam1/100/100',
            ]
        );
        $sam->assignRole('Super Admin');

        // Finance User
        $finance = User::firstOrCreate(
            ['email' => 'finance@alwasisofttech.com'],
            [
                'name' => 'Finance User',
                'company_name' => 'Al-wasi Soft Tech HQ',
                'password' => Hash::make('password'),
                'avatar' => 'https://picsum.photos/seed/finance1/100/100',
            ]
        );
        $finance->assignRole('Finance');

        // Branch Operator
        $branchOperator = User::firstOrCreate(
            ['email' => 'branch.multan@alwasisofttech.com'],
            [
                'name' => 'Branch Multan',
                'company_name' => 'Branch Multan',
                'password' => Hash::make('password'),
                'avatar' => 'https://picsum.photos/seed/branch1/100/100',
            ]
        );
        $branchOperator->assignRole('Branch Operator');

        // Sellers
        $catherine = User::firstOrCreate(
            ['email' => 'catherine@chicboutique.com'],
            [
                'name' => 'Catherine Smith',
                'company_name' => 'Chic Boutique',
                'password' => Hash::make('password'),
                'avatar' => 'https://picsum.photos/seed/seller1/100/100',
            ]
        );
        $catherine->assignRole('Seller');

        $john = User::firstOrCreate(
            ['email' => 'john@gadgetworld.com'],
            [
                'name' => 'John Doe',
                'company_name' => 'Gadget World',
                'password' => Hash::make('password'),
                'avatar' => 'https://picsum.photos/seed/seller2/100/100',
            ]
        );
        $john->assignRole('Seller');

        // Marketing
        $marketing = User::firstOrCreate(
            ['email' => 'marketing@alwasisofttech.com'],
            [
                'name' => 'Marketing Team',
                'company_name' => 'Al-wasi Soft Tech HQ',
                'password' => Hash::make('password'),
                'avatar' => 'https://picsum.photos/seed/marketing1/100/100',
            ]
        );
        $marketing->assignRole('Marketing Manager');

        // Support
        $support = User::firstOrCreate(
            ['email' => 'support@alwasisofttech.com'],
            [
                'name' => 'Support Team',
                'company_name' => 'Al-wasi Soft Tech HQ',
                'password' => Hash::make('password'),
                'avatar' => 'https://picsum.photos/seed/support1/100/100',
            ]
        );
        $support->assignRole('Support');
    }
}
