<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Carbon; // fallback if Carbon alias missing
use Carbon\Carbon as CarbonAlias;
use Illuminate\Support\Facades\DB;

class ZoneRateSeeder extends Seeder
{
    public function run(): void
    {
        $now = class_exists(CarbonAlias::class) ? CarbonAlias::now() : \Carbon\Carbon::now();

        DB::table('zone_rates')->insert([
            [
                'name' => 'Zone A Standard',
                'code' => 'ZONE-A-STD',
                'zone' => 'A',
                'currency' => 'USD',
                'base_rate' => 5.00,
                'additional_per_kg' => 0.50,
                'remote_area_fee' => null,
                'fuel_surcharge_percent' => 8.00,
                'effective_from' => $now->copy()->subDays(7),
                'effective_to' => null,
                'status' => 'active',
                'notes' => 'Standard zone A rate.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Zone B Remote',
                'code' => 'ZONE-B-REM',
                'zone' => 'B-REMOTE',
                'currency' => 'USD',
                'base_rate' => 7.50,
                'additional_per_kg' => 0.75,
                'remote_area_fee' => 3.00,
                'fuel_surcharge_percent' => 10.00,
                'effective_from' => $now->copy()->subDays(3),
                'effective_to' => null,
                'status' => 'active',
                'notes' => 'Remote area surcharge applies.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Zone C Promo',
                'code' => 'ZONE-C-PROMO',
                'zone' => 'C',
                'currency' => 'USD',
                'base_rate' => 4.50,
                'additional_per_kg' => 0.40,
                'remote_area_fee' => null,
                'fuel_surcharge_percent' => 5.00,
                'effective_from' => $now->copy()->addDays(1),
                'effective_to' => $now->copy()->addDays(30),
                'status' => 'inactive',
                'notes' => 'Pending campaign launch.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
        ]);
    }
}