@extends('layouts.admin')

@section('title', 'Add New Bank')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Add New Bank</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Enter the details for the new bank.</p>
    </div>

    <div class="bg-white rounded-lg shadow-md max-w-2xl mx-auto">
        <div class="p-4 sm:p-6 border-b">
            <h2 class="text-lg font-semibold">Bank Details</h2>
        </div>
        <form action="{{ route('admin.banks.store') }}" method="POST" class="p-4 sm:p-6">
            @csrf
            <div class="grid grid-cols-1 gap-4">
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Bank Name</label>
                    <input type="text" id="name" name="name" class="w-full border-gray-300 rounded-md shadow-sm" required>
                </div>
                <div>
                    <label for="account_number" class="block text-sm font-medium text-gray-700 mb-1">Account Number</label>
                    <input type="text" id="account_number" name="account_number" class="w-full border-gray-300 rounded-md shadow-sm" required>
                </div>
                <div>
                    <label for="branch_code" class="block text-sm font-medium text-gray-700 mb-1">Branch Code</label>
                    <input type="text" id="branch_code" name="branch_code" class="w-full border-gray-300 rounded-md shadow-sm">
                </div>
                <div class="flex items-center">
                    <input type="checkbox" id="is_active" name="is_active" value="1" class="h-4 w-4 text-blue-600 border-gray-300 rounded" checked>
                    <label for="is_active" class="ml-2 block text-sm text-gray-900">Set as active</label>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="mt-6 pt-6 border-t flex justify-end gap-3">
                <a href="{{ route('admin.banks.index') }}" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-md text-sm font-semibold hover:bg-gray-300 transition">Cancel</a>
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-blue-700 transition">Add Bank</button>
            </div>
        </form>
    </div>
</div>
@endsection
