{{ ... }}

@section('title', 'Banks')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between mb-4 sm:mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Manage Banks</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Add, edit, and manage bank details.</p>
        </div>
        <div class="mt-3 sm:mt-0">
            <a href="{{ route('admin.banks.create') }}" class="w-full sm:w-auto bg-blue-600 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-blue-700 transition flex items-center justify-center gap-2">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                Add New Bank
            </a>
    </div>

    @if(session('success'))
        <div class="mb-4 p-3 bg-green-50 border border-green-200 text-green-700 rounded text-xs sm:text-sm">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Bank Name</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Code</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">SWIFT</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Active</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($banks as $bank)
                    <tr class="hover:bg-gray-50">
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-gray-900">{{ $bank->bank_name }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $bank->bank_code ?? '-' }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $bank->swift_code ?? '-' }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap">
                            @if($bank->is_active)
                                <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-green-100 text-green-800">Active</span>
                            @else
                                <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-gray-100 text-gray-800">Inactive</span>
                            @endif
                        </td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium space-x-3">
                            <a href="{{ route('admin.banks.show', $bank) }}" class="text-blue-600 hover:text-blue-800">View</a>
                            <a href="{{ route('admin.banks.edit', $bank) }}" class="text-green-600 hover:text-green-800">Edit</a>
                            <form action="{{ route('admin.banks.destroy', $bank) }}" method="POST" class="inline" onsubmit="return confirm('Delete this bank?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-800">Delete</button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-4 py-3 text-center text-xs text-gray-500">No banks found</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="mt-4">{{ $banks->links() }}</div>
</div>
@endsection
