@extends('layouts.admin')

@section('title', 'Bank Details')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-3 sm:mb-4">
        <a href="{{ route('admin.banks.index') }}" class="text-xs sm:text-sm text-blue-600 hover:text-blue-800 font-medium">← Back to Banks</a>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900 mb-4 sm:mb-6">{{ $bank->bank_name }}</h1>
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4 text-xs sm:text-sm">
            <div>
                <p class="text-gray-500">Bank Code</p>
                <p class="text-gray-900">{{ $bank->bank_code ?? '-' }}</p>
            </div>
            <div>
                <p class="text-gray-500">SWIFT Code</p>
                <p class="text-gray-900">{{ $bank->swift_code ?? '-' }}</p>
            </div>
            <div class="sm:col-span-2">
                <p class="text-gray-500">Address</p>
                <p class="text-gray-900">{{ $bank->address ?? '-' }}</p>
            </div>
            <div>
                <p class="text-gray-500">Contact</p>
                <p class="text-gray-900">{{ $bank->contact_number ?? '-' }}</p>
            </div>
            <div>
                <p class="text-gray-500">Status</p>
                <p>
                    @if($bank->is_active)
                        <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-green-100 text-green-800">Active</span>
                    @else
                        <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-gray-100 text-gray-800">Inactive</span>
                    @endif
                </p>
            </div>
        </div>

        <div class="mt-6 flex gap-2 sm:gap-3">
            <a href="{{ route('admin.banks.edit', $bank) }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Edit</a>
            <form method="POST" action="{{ route('admin.banks.destroy', $bank) }}" onsubmit="return confirm('Delete this bank?')">
                @csrf
                @method('DELETE')
                <button type="submit" class="bg-red-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-red-700 transition">Delete</button>
            </form>
        </div>
    </div>
</div>
@endsection


