@extends('layouts.admin')

@section('title', 'Create & Manage Bags')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex justify-between items-center">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Bagging Station</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Create new bags and view recent ones.</p>
        </div>
    </div>

    @if(session('success'))
        <div class="mb-4 p-3 sm:p-4 rounded bg-green-50 text-green-700 text-xs sm:text-sm">
            {{ session('success') }}
        </div>
    @endif
    @if($errors->any())
        <div class="mb-4 p-3 sm:p-4 rounded bg-red-50 text-red-700 text-xs sm:text-sm">
            {{ $errors->first() }}
        </div>
    @endif

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        {{-- Current/Open Bag Section --}}
        <div class="lg:col-span-1 bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <h2 class="text-lg font-semibold mb-4">Current Bag</h2>
            @if(!empty($currentBag))
                <div class="mb-4 text-xs sm:text-sm text-gray-700">
                    <div><span class="font-medium">Bag #:</span> {{ $currentBag->bag_number }}</div>
                    <div><span class="font-medium">Status:</span> {{ ucfirst($currentBag->status) }}</div>
                    @if($currentBag->rider)
                        <div><span class="font-medium">Rider:</span> {{ $currentBag->rider->name }}</div>
                    @endif
                </div>
                <form action="{{ route('admin.branch.bagging.items.add') }}" method="POST" class="mb-3">
                    @csrf
                    <input type="hidden" name="bag_id" value="{{ $currentBag->id }}">
                    <label for="tracking_id" class="block text-xs sm:text-sm font-medium text-gray-700">Scan or enter parcel ID</label>
                    <div class="mt-1 flex gap-2">
                        <input id="tracking_id" name="tracking_id" type="text" class="flex-1 border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="PCL123456">
                        <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add to Bag</button>
                    </div>
                </form>
                @if($currentBag->items->count() > 0)
                    <div class="mb-3">
                        <h3 class="text-sm font-semibold mb-2">Scanned Parcels</h3>
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-3 py-2 text-left text-[11px] font-medium text-gray-500 uppercase">Tracking ID</th>
                                        <th class="px-3 py-2 text-left text-[11px] font-medium text-gray-500 uppercase">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($currentBag->items as $item)
                                        <tr>
                                            <td class="px-3 py-2 text-xs text-gray-700">{{ $item->parcel->tracking_id }}</td>
                                            <td class="px-3 py-2 text-xs text-right">
                                                <form action="{{ route('admin.branch.bagging.items.remove', [$currentBag->id, $item->id]) }}" method="POST" class="inline">
                                                    @csrf
                                                    <button type="submit" class="text-red-600 hover:text-red-800">Remove</button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                @endif
                @if($currentBag->status === 'open')
                <form action="{{ route('admin.branch.bagging.seal', $currentBag->id) }}" method="POST">
                    @csrf
                    <button type="submit" class="bg-indigo-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-indigo-700 transition">Seal Bag</button>
                </form>
                @endif
            @else
                <form action="{{ route('admin.branch.bagging.open') }}" method="POST">
                    @csrf
                    <div class="mb-4">
                        <label for="rider_id" class="block text-xs sm:text-sm font-medium text-gray-700">Assign Rider (optional)</label>
                        <select id="rider_id" name="rider_id" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                            <option value="">Select rider</option>
                            @foreach($riders as $r)
                                <option value="{{ $r->id }}">{{ $r->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Open New Bag</button>
                </form>
            @endif
        </div>

        {{-- Recent bags Section --}}
        <div class="lg:col-span-2 bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <h2 class="text-lg font-semibold mb-4">Recent Bags</h2>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Bag Number</th>
                            <th scope="col" class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Destination</th>
                            <th scope="col" class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Parcels</th>
                            <th scope="col" class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Created At</th>
                            <th scope="col" class="relative px-6 py-3">
                                <span class="sr-only">Actions</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($bags as $bag)
                        <tr>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-gray-900">{{ $bag->bag_number }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">—</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ $bag->items_count ?? $bag->items->count() }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ $bag->created_at->format('d M, Y H:i') }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('admin.branch.bagging.manifest', $bag->id) }}" class="ml-4 text-green-600 hover:text-green-900">Print Manifest</a>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500 text-center">No bags created yet.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection




