@extends('layouts.admin')

@section('title', 'Branch Dashboard')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Branch Dashboard</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Overview of all operations for your branch today</p>
    </div>

    <!-- Stats Grid -->
    <div class="grid grid-cols-2 sm:grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 mb-4 sm:mb-6">
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">Total Parcels</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                </svg>
            </div>
            <p class="text-lg sm:text-xl lg:text-2xl font-bold text-gray-900">{{ $totalParcels }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">All parcels</p>
        </div>

        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">Pending</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
            </div>
            <p class="text-lg sm:text-xl lg:text-2xl font-bold text-yellow-600">{{ $pendingParcels }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">Waiting for pickup</p>
        </div>

        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">In Transit</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                </svg>
            </div>
            <p class="text-lg sm:text-xl lg:text-2xl font-bold text-blue-600">{{ $inTransitParcels }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">On the way</p>
        </div>

        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">Delivered</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                </svg>
            </div>
            <p class="text-lg sm:text-xl lg:text-2xl font-bold text-green-600">{{ $deliveredParcels }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">Successfully delivered</p>
        </div>

        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">Total Riders</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 016-6h6a6 6 0 016 6v1h-3"/>
                </svg>
            </div>
            <p class="text-lg sm:text-xl lg:text-2xl font-bold text-gray-900">{{ $totalRiders }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">All riders</p>
        </div>

        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">Available Riders</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 016-6h6a6 6 0 016 6v1h-3"/>
                </svg>
            </div>
            <p class="text-lg sm:text-xl lg:text-2xl font-bold text-green-600">{{ $availableRiders }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">Ready for dispatch</p>
        </div>
    </div>

    <!-- Recent Parcels -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="px-3 sm:px-4 lg:px-6 py-3 sm:py-4 border-b border-gray-200">
            <h2 class="text-base sm:text-lg font-bold text-gray-900">Recent Parcels</h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Tracking ID</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Recipient</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Rider</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">COD Amount</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($recentParcels as $parcel)
                    <tr>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-blue-600">{{ $parcel->tracking_id }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $parcel->recipient_name }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $parcel->rider->name ?? 'Unassigned' }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">PKR {{ number_format($parcel->cod_amount, 2) }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap">
                            <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full 
                                @if($parcel->status === 'Delivered') bg-green-100 text-green-800
                                @elseif($parcel->status === 'Pending') bg-yellow-100 text-yellow-800
                                @elseif(in_array($parcel->status, ['In Transit', 'Picked Up'])) bg-blue-100 text-blue-800
                                @else bg-red-100 text-red-800
                                @endif">
                                {{ $parcel->status }}
                            </span>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-4 py-3 text-center text-xs text-gray-500">No parcels found</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
