@extends('layouts.admin')

@section('title', 'Deliveries Assigned')

@section('content')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-4">
    <h1 class="text-2xl font-semibold text-gray-900">Deliveries Assigned</h1>

    <div class="mt-4">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Tracking ID
                    </th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Recipient
                    </th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Rider
                    </th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Status
                    </th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach ($parcels as $parcel)
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">
                            {{ $parcel->tracking_id }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            {{ $parcel->recipient_name }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            {{ $parcel->rider->name }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">
                                {{ $parcel->status }}
                            </span>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
