@extends('layouts.admin')

@section('title', 'Bag Manifest')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Bag Manifest</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Printable manifest for sealed bag</p>
        </div>
        <button onclick="window.print()" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700">Print</button>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-2.5 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tracking ID</th>
                    <th class="px-4 py-2.5 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Recipient</th>
                    <th class="px-4 py-2.5 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Address</th>
                    <th class="px-4 py-2.5 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">City</th>
                    <th class="px-4 py-2.5 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">COD Amount</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($parcels as $parcel)
                <tr>
                    <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $parcel->tracking_id }}</td>
                    <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $parcel->recipient_name }}</td>
                    <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $parcel->address }}</td>
                    <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $parcel->city }}</td>
                    <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ number_format($parcel->cod_amount, 2) }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500 text-center">No parcels found for this bag.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection

