@extends('layouts.admin')

@section('title', 'Assigned Deliveries')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex justify-between items-center">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Assigned Deliveries</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Monitor all deliveries that have been assigned to riders.</p>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Tracking #</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Rider</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="relative px-6 py-3">
                            <span class="sr-only">Actions</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($assignedDeliveries as $delivery)
                        <tr>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-gray-900">{{ $delivery['tracking_number'] }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ $delivery['rider'] }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs">
                                <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full 
                                    @switch($delivery['status'])
                                        @case('Out for Delivery') bg-blue-100 text-blue-800 @break
                                        @case('Pending') bg-yellow-100 text-yellow-800 @break
                                    @endswitch">
                                    {{ $delivery['status'] }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="#" class="text-indigo-600 hover:text-indigo-900">View Details</a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection


